def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming the objects are named as per the environment’s context
        cabinet_location = positions['cabinet']
        drawer_location = positions['drawer']
        tomato1_location = positions['tomato1']
        tomato2_location = positions['tomato2']
        plate_location = positions['plate']
        
        gripper = "gripper"  # Just an example; change as needed based on your context

        # 1. Approach and pick tomato1
        print("[Task] Approaching and picking tomato1 at:", tomato1_location)
        obs, reward, done = move(env, "start_position", tomato1_location)
        if done: return

        obs, reward, done = pick(env, "tomato1", tomato1_location, gripper)
        if done: return

        # 2. Approach and open the drawer
        print("[Task] Approaching and opening the drawer at:", drawer_location)
        obs, reward, done = move(env, tomato1_location, drawer_location)
        if done: return
        
        obs, reward, done = pull(env, gripper, drawer_location)
        if done: return

        # 3. Place tomato1 into the drawer
        print("[Task] Placing tomato1 into the drawer")
        obs, reward, done = place(env, "tomato1", drawer_location)
        if done: return

        # 4. Pick up tomato2
        print("[Task] Picking up tomato2 at:", tomato2_location)
        obs, reward, done = move(env, drawer_location, tomato2_location)
        if done: return
        
        obs, reward, done = pick(env, "tomato2", tomato2_location, gripper)
        if done: return

        # 5. Place tomato2 onto the plate
        print("[Task] Placing tomato2 onto the plate at:", plate_location)
        obs, reward, done = move(env, tomato2_location, plate_location)
        if done: return
        
        obs, reward, done = place(env, "tomato2", plate_location)
        if done: return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()