def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Extract object positions from the retrieved data
        bottom_anchor_pos = positions['bottom_anchor_obj']
        bottom_side_pos = positions['bottom_side_obj']
        target_obj = positions['target_obj']  # Example target object, e.g. tomatoes
        
        # === Example Task Plan ===
        # Navigate to bottom side position to interact with the drawer.
        print("[Task] Moving to bottom side position.")
        obs, reward, done = move(env, task, 'room', bottom_side_pos)  
        if done:
            print("[Task] Ended after moving to bottom side position.")
            return

        # Pick the drawer mechanism at bottom anchor position.
        print("[Task] Picking the drawer at bottom anchor position.")
        obs, reward, done = pick(env, 'drawer_handle', bottom_anchor_pos)  
        if done:
            print("[Task] Ended after picking the drawer.")
            return
        
        # Open the drawer to access items inside. 
        print("[Task] Opening the drawer.")
        obs, reward, done = pull(env, task, 'drawer')  
        if done:
            print("[Task] Ended after pulling (opening) the drawer.")
            return
        
        # Now, assuming the target object is inside the drawer, we pick it up.
        print("[Task] Picking the target object.")
        obs, reward, done = pick(env, 'target_obj', 'inside_drawer')
        if done:
            print("[Task] Ended after picking the target object.")
            return
        
        # Move to a 'place' location to drop the target object.
        print("[Task] Moving to target place location.")
        obs, reward, done = move(env, task, bottom_side_pos, 'target_place_location')  
        if done:
            print("[Task] Ended after moving to target place location.")
            return
        
        # Place the object down at the target location.
        print("[Task] Placing the target object.")
        obs, reward, done = place(env, 'target_obj', 'target_place_location')  
        if done:
            print("[Task] Ended after placing the target object.")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()