def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming 'drawer1' and 'drawer2' are known objects in environment
        drawer1_pos = positions['drawer1']  # e.g., position of drawer1
        drawer2_pos = positions['drawer2']  # e.g., position of drawer2
        
        # 1) Move to drawer1's anchor position
        print("[Task] Moving to drawer1")
        obs, reward, done = move(env, task, drawer1_pos, max_steps=100, threshold=0.01)
        if done:
            print("[Task] Task ended after moving to drawer1!")
            return

        # 2) Pick the drawer
        print("[Task] Picking drawer1")
        obs, reward, done = pick(env, 'drawer1', drawer1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking drawer1!")
            return

        # 3) Move to a side position of drawer1
        print("[Task] Moving to side position of drawer1")
        side_pos = (drawer1_pos[0], drawer1_pos[1] - 0.5, drawer1_pos[2])  # Adjust the side position as needed
        obs, reward, done = move(env, task, side_pos, max_steps=100, threshold=0.01)
        if done:
            print("[Task] Task ended after moving to side position of drawer1!")
            return

        # 4) Pull drawer1
        print("[Task] Pulling drawer1")
        obs, reward, done = pull(env, 'drawer1', 'gripper')
        if done:
            print("[Task] Task ended after pulling drawer1!")
            return

        # 5) Move to drawer2's anchor position
        print("[Task] Moving to drawer2")
        obs, reward, done = move(env, task, drawer2_pos, max_steps=100, threshold=0.01)
        if done:
            print("[Task] Task ended after moving to drawer2!")
            return

        # 6) Pick drawer2
        print("[Task] Picking drawer2")
        obs, reward, done = pick(env, 'drawer2', drawer2_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking drawer2!")
            return

        # 7) Move to a side position of drawer2
        print("[Task] Moving to side position of drawer2")
        side_pos2 = (drawer2_pos[0], drawer2_pos[1] - 0.5, drawer2_pos[2])  # Adjust the side position as needed
        obs, reward, done = move(env, task, side_pos2, max_steps=100, threshold=0.01)
        if done:
            print("[Task] Task ended after moving to side position of drawer2!")
            return

        # 8) Pull drawer2
        print("[Task] Pulling drawer2")
        obs, reward, done = pull(env, 'drawer2', 'gripper')
        if done:
            print("[Task] Task ended after pulling drawer2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")