def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # TODO: Replace these placeholder keys with your actual objects
        # Assuming positions has keys that match objects in the domain
        # For example purposes, let's assume there are two objects with known positions
        object1_pos = positions.get('object_1', (0, 0, 0))
        object2_pos = positions.get('object_2', (1, 1, 1))

        # Execute the plan step-by-step
        # Step 1: Move to the initial location of object 1
        print("[Task] Moving to object_1's position:", object1_pos)
        obs, reward, done = move(env, task, target_pos=np.array(object1_pos), max_steps=100, threshold=0.01)
        if done:
            print("[Task] Task ended while moving to object_1!")
            return
        
        # Step 2: Pick object 1
        print("[Task] Picking object_1")
        obs, reward, done = pick(env, 'object_1', 'room_a', 'gripper')  # Assuming object_1 is in room_a
        if done:
            print("[Task] Task ended while picking object_1!")
            return

        # Step 3: Place object 1 in its new location
        print("[Task] Placing object_1 in room_b")
        obs, reward, done = place(env, 'object_1', 'room_b')
        if done:
            print("[Task] Task ended while placing object_1!")
            return

        # Repeat similar steps for object 2
        print("[Task] Moving to object_2's position:", object2_pos)
        obs, reward, done = move(env, task, target_pos=np.array(object2_pos), max_steps=100, threshold=0.01)
        if done:
            print("[Task] Task ended while moving to object_2!")
            return

        print("[Task] Picking object_2")
        obs, reward, done = pick(env, 'object_2', 'room_b', 'gripper')  # Assuming object_2 is in room_b
        if done:
            print("[Task] Task ended while picking object_2!")
            return

        print("[Task] Placing object_2 in room_a")
        obs, reward, done = place(env, 'object_2', 'room_a')
        if done:
            print("[Task] Task ended while placing object_2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()