def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        tomato_position = positions['tomato']
        plate_position = positions['plate']
        drawer_position = positions['drawer']

        # Move to the drawer to open it
        print("[Task] Moving to the drawer.")
        obs, reward, done = move(env, 'room', drawer_position)  # Assuming 'room' as current loc
        if done:
            print("[Task] Task ended while moving to the drawer.")
            return

        # Slide open the drawer
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, 'gripper', 'drawer_handle', drawer_position)
        if done:
            print("[Task] Task ended while pulling the drawer.")
            return
        
        # Pick up the tomato from the drawer
        print("[Task] Picking the tomato.")
        obs, reward, done = pick(env, 'tomato', drawer_position, 'gripper')
        if done:
            print("[Task] Task ended while picking the tomato.")
            return
        
        # Move to the plate
        print("[Task] Moving to the plate.")
        obs, reward, done = move(env, drawer_position, plate_position)
        if done:
            print("[Task] Task ended while moving to the plate.")
            return
            
        # Place the tomato onto the plate
        print("[Task] Placing the tomato on the plate.")
        obs, reward, done = place(env, 'tomato', plate_position)
        if done:
            print("[Task] Task ended while placing the tomato on the plate.")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()