def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extract object positions
        drawer_position = positions['drawer']  # Position of the drawer
        robot_initial_position = positions['robot_start']  # Initial position of the robot
        object1_position = positions['object1']  # Position of object1 to manipulate
        object2_position = positions['object2']  # Position of object2 to manipulate

        # 1) Move robot to the initial position
        print("[Task] Moving robot to the initial position.")
        obs, reward, done = move(env, robot_initial_position, drawer_position)
        if done:
            return

        # 2) Approach and pick the object1
        print("[Task] Picking object1 at:", object1_position)
        obs, reward, done = pick(env, 'object1', object1_position, 'gripper')
        if done:
            return

        # 3) Move the robot to the drop position (assumed to be different from pick)
        print("[Task] Moving robot to drop position.")
        obs, reward, done = move(env, drawer_position, 'drop_position')
        if done:
            return
        
        # 4) Place the object
        print("[Task] Placing object1.")
        obs, reward, done = place(env, 'object1', 'drop_position')
        if done:
            return

        # 5) Repeat steps to manipulate object2 (similar to object1)
        print("[Task] Picking object2 at:", object2_position)
        obs, reward, done = pick(env, 'object2', object2_position, 'gripper')
        if done:
            return

        print("[Task] Moving robot to drop position for object2.")
        obs, reward, done = move(env, drawer_position, 'drop_position')
        if done:
            return
        
        print("[Task] Placing object2.")
        obs, reward, done = place(env, 'object2', 'drop_position')
        if done:
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()