def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define positions based on the feedback given
        bottom_side_pos = positions['bottom_side_pos']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']

        # === Task Plan Execution ===
        
        # Move to the side position to access the drawer
        print("[Task] Moving to the bottom side position.")
        obs, reward, done = move(env, obs.robot, obs.robot_location, bottom_side_pos)
        if done:
            print("[Task] Task ended after moving to the bottom side position!")
            return
        
        # Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick_drawer(env, obs.gripper, obs.drawer, bottom_side_pos)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return
        
        # Rotate the gripper to the correct orientation
        print("[Task] Rotating the gripper to open the drawer.")
        target_quat = [0, 0, 0, 1]  # Example quaternion for the desired orientation
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return
        
        # Pull the drawer open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, obs.gripper, obs.drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
        
        # Place tomato1 on the plate
        print("[Task] Picking tomato1.")
        obs, reward, done = pick(env, 'tomato1', obs.room, obs.gripper)
        if done:
            print("[Task] Task ended after picking tomato1!")
            return
        
        print("[Task] Placing tomato1 on the plate.")
        obs, reward, done = place(env, 'tomato1', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato1 on the plate!")
            return
        
        # Pick tomato2
        print("[Task] Picking tomato2.")
        obs, reward, done = pick(env, 'tomato2', obs.room, obs.gripper)
        if done:
            print("[Task] Task ended after picking tomato2!")
            return
        
        # Place tomato2 on the plate
        print("[Task] Placing tomato2 on the plate.")
        obs, reward, done = place(env, 'tomato2', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato2 on the plate!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")