def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extract necessary positions and initialize variables
        bottom_drawer_pos = positions['bottom_drawer']
        top_drawer_pos = positions['top_drawer']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']
        gripper_pos = positions['gripper']

        # Step 1: Move to bottom drawer position
        print("[Task] Moving to bottom drawer position...")
        obs, reward, done = move(env, gripper_pos, bottom_drawer_pos)
        if done:
            print("[Task] Task ended after moving to bottom drawer!")
            return

        # Step 2: Open bottom drawer
        print("[Task] Opening bottom drawer...")
        obs, reward, done = pick_drawer(gripper_pos, 'bottom_drawer', bottom_drawer_pos)
        if done:
            print("[Task] Task ended after trying to open the drawer!")
            return
        
        # Step 3: Pick up tomato1
        print("[Task] Picking tomato1...")
        obs, reward, done = pick(env, 'tomato1', tomato1_pos)
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 4: Move to plate position
        print("[Task] Moving to plate position...")
        obs, reward, done = move(env, gripper_pos, plate_pos)
        if done:
            print("[Task] Task ended after moving to plate!")
            return

        # Step 5: Place tomato1 on plate
        print("[Task] Placing tomato1 on plate...")
        obs, reward, done = place(env, 'tomato1', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Step 6: Repeat for tomato2
        print("[Task] Moving to bottom drawer position...")
        obs, reward, done = move(env, gripper_pos, bottom_drawer_pos)
        if done:
            print("[Task] Task ended after moving to bottom drawer!")
            return
        
        print("[Task] Opening bottom drawer again...")
        obs, reward, done = pick_drawer(gripper_pos, 'bottom_drawer', bottom_drawer_pos)
        if done:
            print("[Task] Task ended after trying to open the drawer!")
            return

        print("[Task] Picking tomato2...")
        obs, reward, done = pick(env, 'tomato2', tomato2_pos)
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        print("[Task] Moving to plate position...")
        obs, reward, done = move(env, gripper_pos, plate_pos)
        if done:
            print("[Task] Task ended after moving to plate!")
            return

        print("[Task] Placing tomato2 on plate...")
        obs, reward, done = place(env, 'tomato2', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

        print("[Task] Completed all actions successfully.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()