def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming the object names provided in the PDDL and object positions for the initial state
        robot_position = positions['at_robby']
        tomato_position = positions['tomato1']  # Retrieve correct names based on actual object
        plate_position = positions['plate1']
        drawer_position = positions['bottom_side_pos']  # Example drawer names based on feedback

        # Step 1: Move to the drawer position 
        print("[Task] Moving to drawer...")
        obs, reward, done = move(env, robot_position, drawer_position)
        
        if done:
            print("[Task] Task ended during moving to drawer!")
            return

        # Step 2: Open the drawer (pick from side position then pull)
        print("[Task] Opening the drawer...")
        obs, reward, done = pick(env, "drawer_handle", drawer_position, "gripper")
        
        if done:
            print("[Task] Task ended during picking the drawer handle!")
            return
        
        obs, reward, done = pull(env, "gripper", "drawer", drawer_position)
        
        if done:
            print("[Task] Task ended during pulling the drawer!")
            return
        
        # Step 3: Pick tomato from its position
        print("[Task] Picking the tomato...")
        obs, reward, done = pick(env, "tomato1", positions['tomato_position'], "gripper")
        
        if done:
            print("[Task] Task ended during picking the tomato!")
            return
        
        # Step 4: Place the tomato on the plate
        print("[Task] Placing the tomato on the plate...")
        obs, reward, done = place(env, "tomato1", plate_position)
        
        if done:
            print("[Task] Task ended during placing the tomato!")
            return

        print("[Task] Successfully completed placing the tomato on the plate!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()