def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Set object names based on your object positions
        tomato1_pos = positions['tomato1']  # Position of the first tomato
        tomato2_pos = positions['tomato2']  # Position of the second tomato
        drawer_pos = positions['drawer']  # Position of the drawer

        # 1) Move to the first tomato's position
        print("[Task] Moving to the first tomato...")
        obs = move(env, 'start_pos', tomato1_pos)
        
        # 2) Pick up the first tomato
        print("[Task] Picking up the first tomato...")
        obs = pick(env, 'tomato1', tomato1_pos, 'gripper')

        # 3) Move to the drawer
        print("[Task] Moving to the drawer...")
        obs = move(env, tomato1_pos, drawer_pos)

        # 4) Open the drawer (if not open)
        print("[Task] Opening the drawer...")
        obs = rotate(env, 'gripper', 'angle_to_open_drawer', max_steps=100)  # Adjust angle as needed
        obs = pull(env, 'drawer')  # Pull to open the drawer

        # 5) Move to the second tomato's position
        print("[Task] Moving to the second tomato...")
        obs = move(env, drawer_pos, tomato2_pos)

        # 6) Pick up the second tomato
        print("[Task] Picking up the second tomato...")
        obs = pick(env, 'tomato2', tomato2_pos, 'gripper')

        # 7) Move back to the drawer location
        print("[Task] Moving back to the drawer...")
        obs = move(env, tomato2_pos, drawer_pos)

        # 8) Drop the first tomato into the drawer
        print("[Task] Dropping the first tomato into the drawer...")
        obs = place(env, 'tomato1', drawer_pos)

        # 9) Drop the second tomato into the drawer
        print("[Task] Dropping the second tomato into the drawer...")
        obs = place(env, 'tomato2', drawer_pos)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()