def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two tomatoes identified in the positions
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        drawer_pos = positions['drawer']

        # Plan Execution
        # Step 1: Move to the first tomato's position
        print(f"[Task] Moving to the first tomato at: {tomato1_pos}")
        obs, reward, done = move(env, task, obs.robot_position, tomato1_pos)
        if done:
            print("[Task] Task ended while moving to the first tomato!")
            return 
        
        # Step 2: Pick the first tomato
        print("[Task] Picking the first tomato")
        obs, reward, done = pick(env, 'tomato1', tomato1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the first tomato!")
            return 

        # Step 3: Move to the drawer position
        print(f"[Task] Moving to the drawer at: {drawer_pos}")
        obs, reward, done = move(env, task, obs.robot_position, drawer_pos)
        if done:
            print("[Task] Task ended while moving to the drawer!")
            return 

        # Step 4: Pull open the drawer
        print("[Task] Pulling open the drawer")
        obs, reward, done = pull(env, 'drawer', drawer_pos)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return 

        # Step 5: Place the first tomato in the drawer
        print("[Task] Placing the first tomato in the drawer")
        obs, reward, done = place(env, 'tomato1', drawer_pos)
        if done:
            print("[Task] Task ended after placing the first tomato!")
            return 

        # Step 6: Move to the second tomato's position
        print(f"[Task] Moving to the second tomato at: {tomato2_pos}")
        obs, reward, done = move(env, task, obs.robot_position, tomato2_pos)
        if done:
            print("[Task] Task ended while moving to the second tomato!")
            return 

        # Step 7: Pick the second tomato
        print("[Task] Picking the second tomato")
        obs, reward, done = pick(env, 'tomato2', tomato2_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the second tomato!")
            return 

        # Step 8: Move back to the drawer
        print(f"[Task] Moving back to the drawer at: {drawer_pos}")
        obs, reward, done = move(env, task, obs.robot_position, drawer_pos)
        if done:
            print("[Task] Task ended while moving back to the drawer!")
            return 

        # Step 9: Place the second tomato in the drawer
        print("[Task] Placing the second tomato in the drawer")
        obs, reward, done = place(env, 'tomato2', drawer_pos)
        if done:
            print("[Task] Task ended after placing the second tomato!")
            return 

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()