def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        bottom_drawer = positions['bottom_drawer']
        middle_drawer = positions['middle_drawer']
        top_drawer = positions['top_drawer']
        bottom_side_pos = positions['bottom_side_pos']
        middle_side_pos = positions['middle_side_pos']
        top_side_pos = positions['top_side_pos']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        top_anchor_pos = positions['top_anchor_pos']
        tomato = positions['tomato']

        # === Executing the task plan ===
        
        # Step 1: Move to Bottom Side Position
        print("[Task] Moving to Bottom Side Position...")
        obs, reward, done = move(env, obs.robot_pos, bottom_side_pos)
        if done:
            print("[Task] Task ended during movement!")
            return
        
        # Step 2: Pick the Bottom Drawer
        print("[Task] Picking the Bottom Drawer...")
        obs, reward, done = pick(env, bottom_drawer, bottom_side_pos)
        if done:
            print("[Task] Task ended during picking!")
            return
        
        # Step 3: Pull/Unlock the Bottom Drawer
        print("[Task] Pulling the Bottom Drawer...")
        obs, reward, done = pull(env, bottom_drawer, bottom_side_pos)
        if done:
            print("[Task] Task ended during pulling!")
            return

        # Step 4: Move to the Tomato and Pick it
        print("[Task] Moving to the Tomato...")
        obs, reward, done = move(env, obs.robot_pos, tomato)
        if done:
            print("[Task] Task ended during movement!")
            return

        print("[Task] Picking the Tomato...")
        obs, reward, done = pick(env, 'tomato', tomato)
        if done:
            print("[Task] Task ended during picking!")
            return
        
        # Step 5: Move to Bottom Anchor Position
        print("[Task] Moving to Bottom Anchor Position...")
        obs, reward, done = move(env, obs.robot_pos, bottom_anchor_pos)
        if done:
            print("[Task] Task ended during movement!")
            return
        
        # Step 6: Place the Tomato into Bottom Drawer
        print("[Task] Placing the Tomato in Bottom Drawer...")
        obs, reward, done = place(env, 'tomato', bottom_drawer)
        if done:
            print("[Task] Task ended during placing!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()