def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Let's assume we want to manipulate a drawer "drawer1"
        drawer_pos = positions['drawer1']  # Get the position of the drawer

        # Ensure robot approaches the drawer
        print("[Task] Moving to the drawer")
        obs, reward, done = move(env, "room1", "drawer1")
        
        if done:
            print("[Task] Task ended while moving to the drawer!")
            return

        # Pick the drawer using the gripper
        print("[Task] Picking the drawer")
        obs, reward, done = pick(env, "drawer1", "drawer1", "gripper")

        if done:
            print("[Task] Task ended while picking the drawer!")
            return

        # Now that the drawer is held, we need to pull it
        print("[Task] Pulling the drawer")
        obs, reward, done = pull(env, "gripper", "drawer1")

        if done:
            print("[Task] Task ended while pulling the drawer!")
            return

        # Finally, place the drawer back
        print("[Task] Placing the drawer down")
        obs, reward, done = place(env, "drawer1", "room1")

        if done:
            print("[Task] Task ended after placing the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()