def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Define the positions and objects needed
        drawer_position = positions['drawer_position']
        tomato1_position = positions['tomato1_position']
        tomato2_position = positions['tomato2_position']
        plate_position = positions['plate_position']

        # Step 1: Move to the drawer position
        print("[Task] Moving to drawer position:", drawer_position)
        obs, reward, done = move(env, task, obs.robot_position, drawer_position)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return
        
        # Step 2: Open the drawer
        print("[Task] Opening the drawer.")
        obs, reward, done = pull(env, task, obs.gripper, 'drawer')
        if done:
            print("[Task] Task ended after opening the drawer!")
            return

        # Step 3: Pick the tomatoes
        print("[Task] Picking tomato1.")
        obs, reward, done = pick(env, 'tomato1', drawer_position, obs.gripper)
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        print("[Task] Picking tomato2.")
        obs, reward, done = pick(env, 'tomato2', drawer_position, obs.gripper)
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 4: Move to plate position
        print("[Task] Moving to plate position:", plate_position)
        obs, reward, done = move(env, task, obs.robot_position, plate_position)
        if done:
            print("[Task] Task ended after moving to plate!")
            return

        # Step 5: Place the tomatoes on the plate
        print("[Task] Placing tomato1 on the plate.")
        obs, reward, done = place(env, 'tomato1', plate_position)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        print("[Task] Placing tomato2 on the plate.")
        obs, reward, done = place(env, 'tomato2', plate_position)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()