def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Get initial positions
        robot_position = positions['robot']
        object_position = positions['object_1']  # Assuming there's an object named 'object_1'
        drawer_position = positions['drawer']
        
        # Example Steps to Execute the Plan
        print(f"[Task] Moving robot to object position at: {object_position}")
        obs, reward, done = move(env, robot_position, object_position)  # Move to object first
        
        if done:
            print("[Task] Task ended after moving to the object!")
            return

        print("[Task] Picking the object.")
        obs, reward, done = pick(env, 'object_1', object_position, 'gripper')  # Pick the object

        if done:
            print("[Task] Task ended after picking the object!")
            return
        
        print(f"[Task] Moving robot to drawer position at: {drawer_position}.")
        obs, reward, done = move(env, object_position, drawer_position)  # Move to drawer position
        
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return
        
        print("[Task] Placing the object in the drawer.")
        obs, reward, done = place(env, 'object_1', drawer_position)  # Place the object in the drawer

        if done:
            print("[Task] Task ended after placing the object!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()