def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming we have 'drawer' and 'gripper' objects
        drawer_pos = positions['drawer']  # Example based on hypothetical keys
        gripper_pos = positions['gripper']  # Example based on hypothetical keys

        # 1. Move to the drawer
        obs, reward, done = move(env, 'initial_position', drawer_pos)
        if done:
            print("[Task] Ended after moving to the drawer!")
            return

        # 2. Manipulate the drawer: pick it
        obs, reward, done = pick_drawer(env, 'gripper', 'drawer', drawer_pos)
        if done:
            print("[Task] Ended after picking the drawer!")
            return

        # 3. Open the drawer
        obs, reward, done = pull(env, 'gripper', 'drawer')
        if done:
            print("[Task] Ended after pulling the drawer!")
            return

        # 4. Move to another position or object as needed (example: object inside drawer)
        # You would need to define the target object position as per your logic here
        target_object_pos = positions.get('target_object', None)
        if target_object_pos:
            obs, reward, done = move(env, drawer_pos, target_object_pos)
            if done:
                print("[Task] Ended after moving to the target object!")
                return

        # 5. Pick the target object
        obs, reward, done = pick(env, 'target_object', target_object_pos)
        if done:
            print("[Task] Ended after picking the target object!")
            return

        # 6. Place the target object in a new location (example: another position)
        target_place_pos = positions.get('target_place', None)
        if target_place_pos:
            obs, reward, done = place(env, 'target_object', target_place_pos)
            if done:
                print("[Task] Ended after placing the target object!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()