def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve Object Positions
        positions = get_object_positions()

        # Robot manipulates the drawer to obtain tomatoes
        print("[Task] Moving to the drawer position.")
        obs, reward, done = move(env, 'room_a', 'drawer_position')
        if done:
            return

        print("[Task] Picking drawer handle.")
        obs, reward, done = pick(env, 'drawer_handle', 'drawer_position', 'right_gripper')
        if done:
            return
            
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, 'right_gripper', 'drawer', 'drawer_position')
        if done:
            return

        print("[Task] Placing drawer handle back to its original position.")
        obs, reward, done = place(env, 'drawer_handle', 'drawer_position')
        if done:
            return

        print("[Task] Moving to the tomatoes.")
        obs, reward, done = move(env, 'drawer_position', 'tomatoes_position')
        if done:
            return
        
        print("[Task] Picking tomato 1.")
        obs, reward, done = pick(env, 'tomato1', 'drawer_position', 'right_gripper')
        if done:
            return
    
        print("[Task] Placing tomato 1 on the plate.")
        obs, reward, done = place(env, 'tomato1', 'plate_position')
        if done:
            return

        print("[Task] Picking tomato 2.")
        obs, reward, done = pick(env, 'tomato2', 'drawer_position', 'right_gripper')
        if done:
            return

        print("[Task] Placing tomato 2 on the plate.")
        obs, reward, done = place(env, 'tomato2', 'plate_position')
        if done:
            return

        print("[Task] Task completed successfully.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()