def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        gripper_pos = positions['gripper']
        bottom_side_pos = positions['bottom_side_pos']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        top_drawer_pos = positions['top_drawer_pos']
        middle_drawer_pos = positions['middle_drawer_pos']

        # Plan Execution
        print("[Task] Starting to unlock the cabinet by opening drawers...")
        
        # Step 1: Move gripper to bottom anchor position to pick the drawer
        obs, reward, done = move(env, task, gripper_pos, bottom_anchor_pos)
        
        if done:
            print("[Task] Failed to move to bottom anchor position.")
            return
        
        # Step 2: Pick the bottom drawer
        obs, reward, done = pick(env, 'bottom_drawer', bottom_anchor_pos)
        
        if done:
            print("[Task] Task ended after attempting to pick the bottom drawer!")
            return
        
        # Step 3: Pull the bottom drawer to open it
        obs, reward, done = pull(env, 'bottom_drawer', bottom_anchor_pos)
        
        if done:
            print("[Task] Successfully opened the bottom drawer!")
        else:
            print("[Task] Failed to open the bottom drawer.")
            return
        
        # Step 4: Pick tomatoes from the bottom drawer
        obs, reward, done = pick(env, 'tomato', bottom_anchor_pos)
        
        if done:
            print("[Task] Task ended after attempting to pick the tomatoes!")
            return
        
        # Step 5: Move to place tomatoes at the plate position (assume plate position exists)
        plate_pos = positions['plate']  # Assuming plate position is retrieved
        obs, reward, done = move(env, task, bottom_anchor_pos, plate_pos)
        
        if done:
            print("[Task] Failed to move to plate position.")
            return
        
        # Step 6: Place tomatoes on the plate
        obs, reward, done = place(env, 'tomato', plate_pos)
        
        if done:
            print("[Task] Successfully placed the tomatoes on the plate!")
        else:
            print("[Task] Failed to place the tomatoes.")
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")