def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming 'gripper' positioned at some location for this run
        gripper = "gripper"
        drawer = "drawer"  # Placeholder for your drawer object from positions
        drawer_position = positions.get("drawer")  # Replace with actual drawer position key
        side_position = positions.get("side_pos")  # Replace with actual side position key
        anchor_position = positions.get("anchor_pos")  # Replace with actual anchor position key

        # Move gripper to the side position
        print(f"[Task] Move to side position: {side_position}")
        move(env, drawer_position, side_position)

        # Rotate gripper to correct angle
        print("[Task] Rotating gripper to specific orientation.")
        rotate(env, task, target_quat=[0, 0, 0, 1])  # Example quaternion for rotation, adjust as needed

        # Pick the drawer
        print(f"[Task] Picking the drawer at position: {drawer_position}")
        pick(env, drawer, drawer_position, gripper)

        # Move gripper to the anchor position for opening
        print(f"[Task] Moving to anchor position: {anchor_position}")
        move(env, side_position, anchor_position)

        # Pull the drawer handle to open it
        print(f"[Task] Pulling drawer {drawer}")
        pull(env, gripper, drawer, drawer_position)

        # Place the object if needed, assuming the object has been interacted with
        print(f"[Task] Placing object back to its position.")
        place(env, drawer, drawer_position)

    except Exception as e:
        print(f"[Error] Encountered an issue: {e}")
    
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()