def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define positions for the objects based on the environment
        gripper = "gripper"  # Assuming a single gripper
        drawer = "drawer"  # Assuming a drawer object
        position_side = positions['side_position']  # Use actual id from positions
        position_anchor = positions['anchor_position']  # Use actual id from positions
        object_to_pick = "object_to_pick"  # Replace with actual object id

        # 1) Move gripper to side position
        print("[Task] Moving gripper to side position.")
        obs, reward, done = move(env, gripper, positions['initial_position'], position_side)
        if done:
            print("[Task] Task ended after moving to side position!")
            return
        
        # 2) Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick_dresser(env, gripper, drawer, position_side)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return
        
        # 3) Rotate the gripper to align with the drawer
        target_quat = [1, 0, 0, 0]  # Replace with actual quaternion values
        print("[Task] Rotating the gripper.")
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return
        
        # 4) Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
        
        # 5) Place the object in the drawer
        print("[Task] Placing the object in the drawer.")
        obs, reward, done = place(env, object_to_pick, drawer)  # Use actual ids
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()