def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on available data
        bottom_side_pose = positions['bottom_side_pos']
        bottom_anchor_pose = positions['anchor_pos_bottom']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']
        drawer_pos = positions['drawer']

        # === Execute Task Plan ===
        
        # Move to the drawer to open it
        print("[Task] Moving to drawer at:", drawer_pos)
        obs, reward, done = move(env, task, obs.current_position, drawer_pos)
        if done:
            print("[Task] Task ended unexpectedly after moving to the drawer!")
            return

        # Now we need to pick from the drawer
        # Pick the drawer handle
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, "drawer_handle", drawer_pos, "gripper")
        if done:
            print("[Task] Task ended unexpectedly after picking the drawer handle!")
            return

        # Open the drawer
        print("[Task] Pulling the drawer to open it.")
        obs, reward, done = pull(env, "drawer", drawer_pos)
        if done:
            print("[Task] Task ended unexpectedly after pulling the drawer!")
            return

        # Move to the tomatoes to pick one up
        print("[Task] Moving to pick tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, obs.current_position, tomato1_pos)
        if done:
            print("[Task] Task ended unexpectedly after moving to tomato1!")
            return
        
        # Pick the first tomato
        print("[Task] Picking tomato1.")
        obs, reward, done = pick(env, "tomato1", tomato1_pos, "gripper")
        if done:
            print("[Task] Task ended unexpectedly after picking tomato1!")
            return

        # Move to place the tomato on the plate
        print("[Task] Moving to place tomato1 on the plate at:", plate_pos)
        obs, reward, done = move(env, task, obs.current_position, plate_pos)
        if done:
            print("[Task] Task ended unexpectedly after moving to the plate!")
            return

        # Place the first tomato on the plate
        print("[Task] Placing tomato1 on the plate.")
        obs, reward, done = place(env, "tomato1", plate_pos)
        if done:
            print("[Task] Task ended unexpectedly after placing tomato1!")
            return
        
        # Repeat the process for the second tomato
        print("[Task] Moving to pick tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, obs.current_position, tomato2_pos)
        if done:
            print("[Task] Task ended unexpectedly after moving to tomato2!")
            return
        
        print("[Task] Picking tomato2.")
        obs, reward, done = pick(env, "tomato2", tomato2_pos, "gripper")
        if done:
            print("[Task] Task ended unexpectedly after picking tomato2!")
            return
        
        print("[Task] Moving to place tomato2 on the plate at:", plate_pos)
        obs, reward, done = move(env, task, obs.current_position, plate_pos)
        if done:
            print("[Task] Task ended unexpectedly after moving to the plate!")
            return
        
        print("[Task] Placing tomato2 on the plate.")
        obs, reward, done = place(env, "tomato2", plate_pos)
        if done:
            print("[Task] Task ended unexpectedly after placing tomato2!")
            return
        
        print("[Task] Completed the task of moving tomatoes to the plate successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")