def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        gripper = 'gripper'  # Placeholder for the gripper object
        drawer = 'drawer'    # Placeholder for the drawer object
        object_1 = 'object_1'  # Placeholder for the first object to manipulate
        object_2 = 'object_2'  # Placeholder for the second object to manipulate

        # Example positions (replace with actual positions from the environment)
        object_1_pos = positions[object_1]
        object_2_pos = positions[object_2]
        drawer_pos = positions[drawer]

        # Step 1: Move to the first object
        print(f"[Task] Moving to {object_1} at:", object_1_pos)
        obs, reward, done = move(env, 'initial_room', object_1_pos)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # Step 2: Pick the first object
        print(f"[Task] Picking {object_1}")
        obs, reward, done = pick(env, object_1, object_1_pos, gripper)
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Move to the drawer
        print(f"[Task] Moving to {drawer} at:", drawer_pos)
        obs, reward, done = move(env, object_1_pos, drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # Step 4: Open the drawer
        print(f"[Task] Picking the drawer")
        obs, reward, done = pick(env, drawer, drawer_pos, gripper)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        print(f"[Task] Pulling the drawer")
        obs, reward, done = pull(env, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 5: Place the first object in the drawer
        print(f"[Task] Placing {object_1} in the drawer")
        obs, reward, done = place(env, task, drawer_pos)
        if done:
            print("[Task] Task ended after placing object_1 in the drawer!")
            return

        # Step 6: Move to the second object
        print(f"[Task] Moving to {object_2} at:", object_2_pos)
        obs, reward, done = move(env, drawer_pos, object_2_pos)
        if done:
            print("[Task] Task ended after moving to object_2!")
            return

        # Step 7: Pick the second object
        print(f"[Task] Picking {object_2}")
        obs, reward, done = pick(env, object_2, object_2_pos, gripper)
        if done:
            print("[Task] Task ended after picking object_2!")
            return

        # Step 8: Move back to the drawer
        print(f"[Task] Moving back to the drawer")
        obs, reward, done = move(env, object_2_pos, drawer_pos)
        if done:
            print("[Task] Task ended after moving back to drawer!")
            return

        # Step 9: Place the second object in the drawer
        print(f"[Task] Placing {object_2} in the drawer")
        obs, reward, done = place(env, task, drawer_pos)
        if done:
            print("[Task] Task ended after placing object_2 in the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")