import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        plate_pos = positions['plate']
        item1_pos = positions['item1']
        item2_pos = positions['item2']

        # === Oracle Plan Execution ===
        # Step 1: pick up item1
        print("[Task] Step 1: Picking up item1 at:", item1_pos)
        # Step 2: place item1 on plate
        print("[Task] Step 2: Placing item1 on plate at:", plate_pos)
        # Step 3: pick up item2
        print("[Task] Step 3: Picking up item2 at:", item2_pos)

        [Frozen Code Start]
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        obs, reward, done = pick(env, task, target_pos=item2_pos)
        [Frozen Code End]

        # Early exit if the last pick ended the episode
        if done:
            print("[Task] Terminated early after pick(item2). Reward:", reward)
            return

        # Step 4: place item2 on plate
        print("[Task] Step 4: Placing item2 on plate at:", plate_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False). Reward:", reward)

    except Exception as e:
        print(f"[Task] Exception during execution: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()