import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Convert to numpy arrays for compatibility with skill functions
        plate_pos = np.array(positions['plate'])
        item1_pos = np.array(positions['item1'])
        item2_pos = np.array(positions['item2'])
        item3_pos = np.array(positions['item3'])

        # === Task Plan Execution ===
        # Execute the oracle plan steps in order
        
        [Frozen Code Start]
    obs, reward, done = pick(env, task, target_pos=item1_pos)
obs, reward, done = place(env, task, target_pos=plate_pos)
obs, reward, done = pick(env, task, target_pos=item3_pos)
obs, reward, done = place(env, task, target_pos=plate_pos)
obs, reward, done = pick(env, task, target_pos=item2_pos)
obs, reward, done = place(env, task, target_pos=plate_pos)
        [Frozen Code End]

        # Check if the task ended prematurely
        if done:
            print("[Task] Task ended prematurely. Reward:", reward)
            return

        # All steps completed
        print("[Task] Completed all steps. Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()