import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        plate_pos = positions.get('plate')
        if plate_pos is None:
            raise ValueError("Position for 'plate' not found.")
        item1_pos = positions.get('tomato1')
        if item1_pos is None:
            raise ValueError("Position for 'tomato1' not found.")
        item2_pos = positions.get('tomato2')
        if item2_pos is None:
            raise ValueError("Position for 'tomato2' not found.")

        obs, reward, done = pick(env, task, target_pos=item1_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)

        if done:
            print("[Task] Terminated after placing 'tomato1'.")
            return

        print("[Task] Picking 'tomato2' at:", item2_pos)
        obs, reward, done = pick(env, task, target_pos=item2_pos)
        if done:
            print("[Task] Terminated after picking 'tomato2'.")
            return

        print("[Task] Placing 'tomato2' on 'plate' at:", plate_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Terminated after placing 'tomato2'.")
            return

        # Final status
        if done:
            print("[Task] Task completed with reward:", reward)
        else:
            print("[Task] Task finished without termination flag. Reward:", reward)

    except Exception as e:
        print(f"[Task] Exception during execution: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()