import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running the disposal task of tossing two tomatoes onto the plate.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Validate that the physical names exist
        if 'tomato1' not in positions or 'tomato2' not in positions or 'plate' not in positions:
            raise KeyError("Missing one of required object positions: tomato1, tomato2, plate")

        # Map the domain keys used in the frozen plan to the actual object names
        positions['item1'] = positions['tomato1']
        positions['item2'] = positions['tomato2']

        # === Oracle Plan Execution ===
        # We follow the frozen plan steps exactly here:

        # Step 1: pick item1 (tomato1) from table
        print(f"[Task] Step 1: Picking tomato1 at position {positions['item1']}")
[Frozen Code Start]
    obs, reward, done = pick(
            env,
            task,
            target_pos=positions['item1'],
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
obs, reward, done = place(
            env,
            task,
            target_pos=positions['plate'],
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
obs, reward, done = pick(
            env,
            task,
            target_pos=positions['item2'],
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
[Frozen Code End]

        # After executing the frozen steps, check if the task ended early
        if done:
            print("[Task] Terminated early during frozen steps. Reward:", reward)
            return

        # Step 4: place item2 (tomato2) onto the plate
        print(f"[Task] Step 4: Placing tomato2 onto plate at position {positions['plate']}")
        obs, reward, done = place(
            env,
            task,
            target_pos=positions['plate'],
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Terminated early after placing tomato2. Reward:", reward)
            return

        # If we reach here, all steps have completed successfully
        print("[Task] Completed all steps. Final reward:", reward)

    except Exception as e:
        print(f"[Task] Exception encountered during execution: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()