import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running the tomato disposal task.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # We alias variables so that the frozen region picks and places the two tomatoes in order:
        #   tomato2_pos -> tomato1, item1_pos -> tomato2
        tomato2_pos = positions['tomato1']
        plate_pos    = positions['plate']
        item1_pos    = positions['tomato2']

        # === Execute Oracle Plan ===

        # Step 1 & 2 and Step 3 are handled by the frozen region below

        # [Frozen Code Start]
        obs, reward, done = pick(env, task, tomato2_pos)
        obs, reward, done = place(env, task, plate_pos)
        obs, reward, done = pick(env, task, item1_pos)
        # [Frozen Code End]

        # If the frozen region ended the episode early, bail out
        if done:
            print("[Task] Early termination after frozen-region steps. Reward:", reward)
            return

        # Step 4: Place the second tomato (item1_pos alias) onto the plate
        print("[Task] Placing second tomato on plate at:", plate_pos)
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Early termination after placing second tomato. Reward:", reward)
            return

        # Final status
        print("[Task] Task completed successfully! Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()