import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # you don't need to redefine primitives like move, pick, place

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Extract positions for objects used in the plan
        tomato2_pos = positions.get('tomato2')
        plate_pos   = positions.get('plate')
        item1_pos   = positions.get('item1')

        # === Execute Oracle Plan ===

        # Step 1: Pick tomato2 from table
        print("[Task] Step 1: Picking tomato2 at:", tomato2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato2_pos
        )
[Frozen Code Start]
        obs, reward, done = pick(
                env,
                task,
                target_pos=tomato2_pos
            )
[Frozen Code End]

        # After frozen region: continue plan
        if done:
            print("[Task] Terminated after Step 1. Reward:", reward)
            return

        # Step 2: Place tomato2 onto plate
        print("[Task] Step 2: Placing tomato2 at:", plate_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos
        )
        if done:
            print("[Task] Terminated after Step 2. Reward:", reward)
            return

        # Step 3: Pick tomato1 from table
        tomato1_pos = positions.get('tomato1')
        print("[Task] Step 3: Picking tomato1 at:", tomato1_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato1_pos
        )
        if done:
            print("[Task] Terminated after Step 3. Reward:", reward)
            return

        # Step 4: Place tomato1 onto plate
        print("[Task] Step 4: Placing tomato1 at:", plate_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos
        )
        if done:
            print("[Task] Terminated after Step 4. Reward:", reward)
            return

        # All plan steps executed
        if not done:
            print("[Task] Task completed successfully! Reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()