import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation (optional)
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        tomato1_pos = positions.get('tomato1')
        tomato2_pos = positions.get('tomato2')
        plate_pos   = positions.get('plate')
        if tomato1_pos is None or tomato2_pos is None or plate_pos is None:
            print("Error: Required object positions ('tomato1', 'tomato2', or 'plate') not found.")
            return

        # Step 1: pick tomato1 from table
        print(f"[Task] Picking tomato1 at: {tomato1_pos}")
        try:
            obs, reward, done = pick(
                env,
                task,
                target_pos=np.array(tomato1_pos),
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"Exception during pick tomato1: {e}")
            return
        if done:
            print(f"[Task] Task ended after pick tomato1! Reward: {reward}")
            return

        # Step 2: place tomato1 on plate
        print(f"[Task] Placing tomato1 on plate at: {plate_pos}")
        try:
            obs, reward, done = place(
                env,
                task,
                target_pos=np.array(plate_pos),
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"Exception during place tomato1: {e}")
            return
        if done:
            print(f"[Task] Task ended after place tomato1! Reward: {reward}")
            return

        # Step 3: pick tomato2 from table
        print(f"[Task] Picking tomato2 at: {tomato2_pos}")
        try:
[Frozen Code Start]
            obs, reward, done = pick(
                env,
                task,
                target_pos=np.array(tomato2_pos)
[Frozen Code End]
                ,approach_distance=0.15
                ,max_steps=100
                ,threshold=0.01
                ,approach_axis='z'
                ,timeout=10.0
            )
        except Exception as e:
            print(f"Exception during pick tomato2: {e}")
            return
        if done:
            print(f"[Task] Task ended after pick tomato2! Reward: {reward}")
            return

        # Step 4: place tomato2 on plate
        print(f"[Task] Placing tomato2 on plate at: {plate_pos}")
        try:
            obs, reward, done = place(
                env,
                task,
                target_pos=np.array(plate_pos),
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"Exception during place tomato2: {e}")
            return
        if done:
            print(f"[Task] Task completed successfully! Reward: {reward}")
        else:
            print("[Task] Task not completed yet (done=False).")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()