import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        plate_pos = positions['plate']
        item1_pos = positions['item1']
        tomato2_pos = positions['tomato2']

        # === Task Plan Execution ===

        # Step 1: Pick up item1 from its location
        print("[Task] Picking up item1 at:", item1_pos)
        try:
            obs, reward, done = pick(env, task, target_pos=item1_pos)
        except Exception as e:
            print(f"[Error] pick(item1) failed: {e}")
            return
        if done:
            print("[Task] Task ended after pick(item1).")
            return

        # Step 2: Place item1 onto the plate
        print("[Task] Placing item1 on plate at:", plate_pos)
        try:
            obs, reward, done = place(env, task, target_pos=plate_pos)
        except Exception as e:
            print(f"[Error] place(item1) failed: {e}")
            return
        if done:
            print("[Task] Task ended after place(item1).")
            return

        # Step 3: Pick up tomato2 from its location
        print("[Task] Picking up tomato2 at:", tomato2_pos)
        try:
            obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        except Exception as e:
            print(f"[Error] pick(tomato2) failed: {e}")
            return
        if done:
            print("[Task] Task ended after pick(tomato2).")
            return

        # Step 4: Place tomato2 onto the plate
        print("[Task] Placing tomato2 on plate at:", plate_pos)
        try:
            obs, reward, done = place(env, task, target_pos=plate_pos)
        except Exception as e:
            print(f"[Error] place(tomato2) failed: {e}")
            return
        if done:
            print("[Task] Task ended after place(tomato2).")
            return

        # Final assessment
        if not done:
            print("[Task] Plan execution completed successfully. Final reward:", reward)
        else:
            print("[Task] Done flag raised. Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()