import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Execute the oracle plan: pick up all tomatoes from the table and place them on the plate.'''
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset the task and initialize video recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        # Wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve current object positions
        positions = get_object_positions()
        # Ensure required objects are present
        required = ['tomato1', 'tomato2', 'plate']
        for obj in required:
            if obj not in positions:
                raise KeyError(f"Required object not found in positions: {obj}")
        tomato1_pos = np.array(positions['tomato1'])
        tomato2_pos = np.array(positions['tomato2'])
        plate_pos   = np.array(positions['plate'])

        # Step 1: pick tomato1 from table
        print(f"[Task] Step 1: pick tomato1 at {tomato1_pos}")
        try:
            obs, reward, done = pick(
                env,
                task,
                target_pos=tomato1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Task] Exception during pick tomato1: {e}")
            return
        if done:
            print(f"[Task] Task ended after picking tomato1 with done=True, reward={reward}")
            return

        # Step 2: place tomato1 on plate
        print(f"[Task] Step 2: place tomato1 on plate at {plate_pos}")
        try:
            obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Task] Exception during place tomato1: {e}")
            return
        if done:
            print(f"[Task] Task ended after placing tomato1 with done=True, reward={reward}")
            return

        # Step 3 & 4: use frozen code to pick and place tomato2
        [Frozen Code Start]
    obs, reward, done = pick(
                env,
                task,
                target_pos=tomato2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        [Frozen Code End]

        # Final check
        if done:
            print(f"[Task] Task completed successfully with all tomatoes! Reward: {reward}")
        else:
            print(f"[Task] Plan executed but done=False at final step. Reward: {reward}")

    finally:
        shutdown_environment(env)
        print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()