# run_skeleton_task.py  
import numpy as np  
from pyrep.objects.shape import Shape  
from pyrep.objects.proximity_sensor import ProximitySensor  

from env import setup_environment, shutdown_environment  

from skill_code import *  

from video import init_video_writers, recording_step, recording_get_observation  

# This module is assumed to provide object positions or other info about the environment  
from object_positions import get_object_positions  

[Frozen Code Start]  
    obs, reward, done = pick(  
            env,  
            task,  
            target_pos=np.array(tomato1_pos)  
    )  
    obs, reward, done = place(  
            env,  
            task,  
            target_pos=np.array(plate_pos)  
    )  
[Frozen Code End]  

def run_skeleton_task():  
    '''Generic skeleton for running any task in your simulation.'''  
    print("===== Starting Skeleton Task =====")  

    # === Environment Setup ===  
    env, task = setup_environment()  
    try:  
        # Reset the task to its initial state  
        descriptions, obs = task.reset()  

        # (Optional) Initialize video writers for capturing your simulation  
        init_video_writers(obs)  

        # Wrap the task steps for recording (if needed)  
        original_step = task.step  
        task.step = recording_step(original_step)  
        original_get_obs = task.get_observation  
        task.get_observation = recording_get_observation(original_get_obs)  

        # === Retrieve Object Positions ===  
        positions = get_object_positions()  
        try:  
            table_pos   = positions['table']  
            plate_pos   = positions['plate']  
            tomato1_pos = positions['item1']  
            tomato2_pos = positions['tomato2']  
        except KeyError as e:  
            print(f"[Error] Missing object in positions: {e}")  
            return  

        # === Execute Oracle Plan ===  
        # Step 1 & 2: pick tomato1 from table and place on plate  
        print("[Task] Step 1: pick tomato1 from table at:", tomato1_pos)  
[Frozen Code Start]  
        obs, reward, done = pick(  
                env,  
                task,  
                target_pos=np.array(tomato1_pos)  
        )  
        if done:  
            print("[Task] Finished early after pick(tomato1). Reward:", reward)  
            return  
        print("[Task] Step 2: place tomato1 onto plate at:", plate_pos)  
        obs, reward, done = place(  
                env,  
                task,  
                target_pos=np.array(plate_pos)  
        )  
        if done:  
            print("[Task] Finished early after place(tomato1). Reward:", reward)  
            return  
[Frozen Code End]  

        # Step 3: pick tomato2 from table  
        print("[Task] Step 3: pick tomato2 from table at:", tomato2_pos)  
        obs, reward, done = pick(  
            env,  
            task,  
            target_pos=np.array(tomato2_pos)  
        )  
        if done:  
            print("[Task] Finished early after pick(tomato2). Reward:", reward)  
            return  

        # Step 4: place tomato2 onto plate  
        print("[Task] Step 4: place tomato2 onto plate at:", plate_pos)  
        obs, reward, done = place(  
            env,  
            task,  
            target_pos=np.array(plate_pos)  
        )  
        if done:  
            print("[Task] Finished early after place(tomato2). Reward:", reward)  
            return  

        # === Task Complete ===  
        print("[Task] Completed all steps. Final reward:", reward)  

    finally:  
        # Always ensure the environment is properly shutdown  
        shutdown_environment(env)  

    print("===== End of Skeleton Task =====")  


if __name__ == "__main__":  
    run_skeleton_task()