import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Task logic for picking up all tomatoes and placing them on the plate.'''
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset the task to its initial state and set up video recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve current object positions from the environment
        positions = get_object_positions()
        tomato2_pos = positions['tomato2']
        tomato1_pos = positions['tomato1']
        plate_pos = positions['plate']

        # Step 1: Pick up tomato2 from its current location
        print("[Task] Picking up tomato2 at:", tomato2_pos)
        obs, reward, done = pick(
                env,
                task,
                target_pos=tomato2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        if done:
            print("[Task] Task ended during pick of tomato2! Reward:", reward)
            return

        # Step 2: Place tomato2 onto the plate
        print("[Task] Placing tomato2 on plate at:", plate_pos)
        obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        if done:
            print("[Task] Task ended during place of tomato2! Reward:", reward)
            return

        # Step 3: Pick up tomato1 from its current location
        print("[Task] Picking up tomato1 at:", tomato1_pos)
        obs, reward, done = pick(
                env,
                task,
                target_pos=tomato1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        if done:
            print("[Task] Task ended during pick of tomato1! Reward:", reward)
            return

        # Step 4: Place tomato1 onto the plate
        print("[Task] Placing tomato1 on plate at:", plate_pos)
        obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        if done:
            print("[Task] Task completed successfully after placing tomato1! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False). Reward:", reward)

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()