from env import setup_environment, shutdown_environment
import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)
        task.step = recording_step(task.step)
        task.get_observation = recording_get_observation(task.get_observation)

        positions = get_object_positions()
        try:
            tomato1_pos = np.array(positions['tomato1'])
            tomato2_pos = np.array(positions['tomato2'])
            plate_pos   = np.array(positions['plate'])
        except KeyError as e:
            print(f"[Error] Missing position for {e}. Cannot execute plan.")
            return

        # === Execute Oracle Plan ===

        print(f"[Task] Step 1: Picking tomato1 from table at {tomato1_pos}")
        # Frozen Code Start
        obs, reward, done = pick(
                env, task,
                target_pos=tomato1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        obs, reward, done = place(
                env, task,
                target_pos=plate_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        obs, reward, done = pick(
                env, task,
                target_pos=tomato2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        # Frozen Code End

        if done:
            print("[Task] Task ended unexpectedly after picking tomato2.")
            return

        print(f"[Task] Step 4: Placing tomato2 onto plate at {plate_pos}")
        obs, reward, done = place(
            env, task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended unexpectedly after placing tomato2.")
            return

        print(f"[Task] Completed all steps. Final reward: {reward}, done flag: {done}")

    finally:
        shutdown_environment(env)
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()