def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two tomatoes to pick and a plate to place them on
        tomato1_pos = positions.get('tomato1')
        tomato2_pos = positions.get('tomato2')
        plate_pos = positions.get('plate')

        # Check if the tomatoes are present in the environment
        if tomato1_pos is None or tomato2_pos is None or plate_pos is None:
            print("Error: One or more required objects (tomato1, tomato2, plate) are not found in the environment.")
            return

        # Step 1: Move to tomato1
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Pick tomato1
        print("[Task] Picking tomato1.")
        obs, reward, done = pick(env, 'tomato1', 'table', 'gripper')
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 3: Move to plate
        print("[Task] Moving to plate at:", plate_pos)
        obs, reward, done = move(env, task, obs.robot_position, plate_pos)
        if done:
            print("[Task] Task ended after moving to plate!")
            return

        # Step 4: Place tomato1 on plate
        print("[Task] Placing tomato1 on plate.")
        obs, reward, done = place(env, 'tomato1', 'plate')
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Step 5: Move to tomato2
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 6: Pick tomato2
        print("[Task] Picking tomato2.")
        obs, reward, done = pick(env, 'tomato2', 'table', 'gripper')
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 7: Move to plate again
        print("[Task] Moving to plate at:", plate_pos)
        obs, reward, done = move(env, task, obs.robot_position, plate_pos)
        if done:
            print("[Task] Task ended after moving to plate!")
            return

        # Step 8: Place tomato2 on plate
        print("[Task] Placing tomato2 on plate.")
        obs, reward, done = place(env, 'tomato2', 'plate')
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()