def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        switch_pos = positions['switch']
        bin_pos = positions['bin']

        # Step 1: Move to tomato1
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Pick tomato1
        print("[Task] Picking tomato1")
        obs, reward, done = pick(env, task, 'tomato1', obs.robot_position)
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 3: Move to switch
        print("[Task] Moving to switch at:", switch_pos)
        obs, reward, done = move(env, task, obs.robot_position, switch_pos)
        if done:
            print("[Task] Task ended after moving to switch!")
            return

        # Step 4: Close gripper
        print("[Task] Closing gripper")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Step 5: Press the switch
        print("[Task] Pressing the switch")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 6: Move to bin
        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, task, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Step 7: Place tomato1 in bin
        print("[Task] Placing tomato1 in bin")
        obs, reward, done = place(env, task, 'tomato1', bin_pos)
        if done:
            print("[Task] Task ended after placing tomato1 in bin!")
            return

        # Step 8: Move to tomato2
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 9: Pick tomato2
        print("[Task] Picking tomato2")
        obs, reward, done = pick(env, task, 'tomato2', obs.robot_position)
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 10: Move to bin
        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, task, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Step 11: Place tomato2 in bin
        print("[Task] Placing tomato2 in bin")
        obs, reward, done = place(env, task, 'tomato2', bin_pos)
        if done:
            print("[Task] Task ended after placing tomato2 in bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()