import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # According to specification, we need to pick 'rubbish' and place it into 'bin'
        item1_pos = positions.get('rubbish')
        bin_pos = positions.get('bin')

        if item1_pos is None or bin_pos is None:
            raise ValueError("Failed to find required object positions for 'rubbish' or 'bin'")

        # === Task Plan Execution ===
        # Step 1: Pick up rubbish from its current location
        print("[Task] Step 1: Picking up rubbish at:", item1_pos)
[Frozen Code Start]
        obs, reward, done = pick(
            env,
            task,
            target_pos=item1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
[Frozen Code End]
        if done:
            print("[Task] Task ended early during pick! Reward:", reward)
            return

        # Step 2: Place rubbish into the bin
        print("[Task] Step 2: Placing rubbish into bin at:", bin_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=bin_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed. done flag is False. Current reward:", reward)

    except Exception as e:
        print(f"[Task] Encountered exception during execution: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()