import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

[Frozen Code Start]

[Frozen Code End]

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Convert to numpy arrays for skill calls
        rubbish_pos = np.array(positions['rubbish'])
        bin_pos = np.array(positions['bin'])

        # === Execute Oracle Plan ===
        # Step 1: pick up the rubbish from the table
        print("[Task] Step 1: pick rubbish from table at:", rubbish_pos)
        try:
            obs, reward, done = pick(
                env,
                task,
                target_pos=rubbish_pos
            )
        except Exception as e:
            print(f"[Task] Exception during pick: {e}")
            return
        if done:
            print("[Task] Task ended prematurely during pick! Reward:", reward)
            return

        # Step 2: place the rubbish into the trash can
        print("[Task] Step 2: place rubbish into bin at:", bin_pos)
        try:
            obs, reward, done = place(
                env,
                task,
                target_pos=bin_pos
            )
        except Exception as e:
            print(f"[Task] Exception during place: {e}")
            return

        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task did not finish (done=False). Reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()