import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        item1_pos = positions['item1']
        tomato2_pos = positions['tomato2']
        item2_pos = positions['item2']
        bin_pos = positions['bin']
        # Position of the rubbish object (we assume get_object_positions returns this)
        rubbish_pos = positions['rubbish']

        # === Oracle Plan Execution (Frozen) ===
        # Do not modify these lines
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        obs, reward, done = place(env, task, target_pos=bin_pos)
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        obs, reward, done = place(env, task, target_pos=bin_pos)
        obs, reward, done = pick(env, task, target_pos=item2_pos)
        # End of frozen region

        # === Specification Steps for Rubbish Disposal ===
        # Step 1: pick the rubbish from the table
        print("[Task] Picking up rubbish at:", rubbish_pos)
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Terminated early after pick(rubbish).")
            return

        # Step 2: place the rubbish into the bin
        print("[Task] Placing rubbish into bin at:", bin_pos)
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Terminated early after place(rubbish).")
            return

        # If we reach here, the pick-and-place of rubbish has completed
        print("[Task] Completed pick-and-place of rubbish. Final reward:", reward)

    except Exception as e:
        print("[Task] Exception occurred during execution:", str(e))
        raise
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()