import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import pick, place

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Task: drop the rubbish into the bin =====")
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers if desired
        init_video_writers(obs)

        # Wrap step and get_observation for recording
        task.step = recording_step(task.step)
        task.get_observation = recording_get_observation(task.get_observation)

        # Retrieve object positions
        positions = get_object_positions()
        if 'rubbish' not in positions or 'bin' not in positions:
            raise KeyError("Required objects 'rubbish' or 'bin' not found in positions")

        # Convert to numpy arrays
        rubbish_pos = np.array(positions['rubbish'])
        bin_pos     = np.array(positions['bin'])

        # To satisfy frozen code naming
        item2_pos = rubbish_pos

        print(f"[Task] Step 1: Picking 'rubbish' at position {item2_pos}")
        # Frozen Code Start
        obs, reward, done = pick(
                env,
                task,
                target_pos=item2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        obs, reward, done = place(
                env,
                task,
                target_pos=bin_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        # Frozen Code End

        if done:
            print("[Task] Task ended during execution. Reward:", reward)
            return

        print("[Task] Task completed successfully! Final reward:", reward)

    except Exception as e:
        print("Exception during task execution:", str(e))
    finally:
        shutdown_environment(env)
        print("===== End of Task =====")

if __name__ == "__main__":
    run_skeleton_task()