import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # We assume 'item1' is the rubbish and 'bin' is the trash can
        rubbish_name = 'item1'
        bin_name = 'bin'
        if rubbish_name not in positions or bin_name not in positions:
            raise KeyError(f"Required object not found in positions: {rubbish_name} or {bin_name}")
        rubbish_pos = positions[rubbish_name]
        bin_pos = positions[bin_name]

        # === Plan Execution ===
        # Step 1: pick up the rubbish (item1)
        print(f"[Task] Picking up rubbish '{rubbish_name}' at position: {rubbish_pos}")
        [Frozen Code Start]
        obs, reward, done = pick(
                env,
                task,
                target_pos=rubbish_pos
            )
        [Frozen Code End]
        if done:
            print("[Task] Task ended after pick step! Reward:", reward)
            return

        # Step 2: place the rubbish into the bin
        print(f"[Task] Placing rubbish into '{bin_name}' at position: {bin_pos}")
        obs, reward, done = place(
            env,
            task,
            target_pos=bin_pos
        )
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False). Reward so far:", reward)

    except Exception as e:
        print("[Task] Exception during task execution:", e)
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()