def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a rubbish object to pick and a location to place it
        rubbish_pos = positions['rubbish']
        drop_location = positions['drop_zone']  # Assuming there's a drop zone defined

        # Step 1: Move to the rubbish location
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, current_pos=obs.robot_pos, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 2: Close the gripper to prepare for picking
        print("[Task] Closing gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Step 3: Pick the rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking rubbish!")
            return

        # Step 4: Move to the drop location
        print("[Task] Moving to drop location at:", drop_location)
        obs, reward, done = move(env, task, current_pos=obs.robot_pos, target_pos=drop_location)
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Step 5: Place the rubbish down
        print("[Task] Placing rubbish down.")
        obs, reward, done = place(env, 'rubbish', drop_location)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()