def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are 'plate', 'item1', 'item2', 'item3', 'switch', 'bin'
        plate_pos = positions['plate']
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        item3_pos = positions['item3']
        switch_pos = positions['switch']
        bin_pos = positions['bin']

        # Step 1: Move to the plate
        print("[Task] Moving to the plate at:", plate_pos)
        obs, reward, done = move(env, 'room_a', 'room_b')  # Example rooms
        if done:
            print("[Task] Task ended while moving to the plate!")
            return

        # Step 2: Pick the plate
        print("[Task] Picking the plate...")
        obs, reward, done = pick(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Task ended after picking the plate!")
            return

        # Step 3: Move to the switch
        print("[Task] Moving to the switch at:", switch_pos)
        obs, reward, done = move(env, 'room_b', 'room_c')  # Example rooms
        if done:
            print("[Task] Task ended while moving to the switch!")
            return

        # Step 4: Press the switch
        print("[Task] Pressing the switch...")
        obs, reward, done = press(env, 'switch')
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 5: Move to the bin
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, 'room_c', 'room_d')  # Example rooms
        if done:
            print("[Task] Task ended while moving to the bin!")
            return

        # Step 6: Place the plate in the bin
        print("[Task] Placing the plate in the bin...")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task ended after placing the plate in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()