def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'rubbish' and 'switch'
        rubbish_pos = positions.get('rubbish')
        switch_pos = positions.get('switch')

        # Check if the rubbish object exists
        if rubbish_pos is None:
            print("Error: Rubbish object not found in the environment.")
            return

        # Move to the rubbish location
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, 'room', rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Pick up the rubbish
        print("[Task] Picking up rubbish...")
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Move to the switch location
        print("[Task] Moving to switch at:", switch_pos)
        obs, reward, done = move(env, rubbish_pos, switch_pos)
        if done:
            print("[Task] Task ended after moving to switch!")
            return

        # Close the gripper (if needed)
        print("[Task] Closing gripper...")
        obs, reward, done = close_gripper(env)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Press the switch
        print("[Task] Pressing the switch...")
        obs, reward, done = press(env, 'switch')
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Place the rubbish down (assuming we have a place position)
        print("[Task] Placing rubbish down...")
        obs, reward, done = place(env, task, target_pos='some_place_position')
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()