def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball object to pick and a room to place it in
        ball_pos = positions['ball']  # Replace 'ball' with the actual object name
        room_pos = positions['room']   # Replace 'room' with the actual room name

        # Check if the room is dark and if the gripper is closed
        if not obs.dark and obs.gripper_closed:
            print("[Task] The room is not dark and the gripper is closed. Proceeding with the task.")
            
            # Step 1: Pick the ball
            print("[Task] Picking the ball at:", ball_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=ball_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after picking the ball!")
                return
            
            # Step 2: Place the ball in the room
            print("[Task] Placing the ball in the room at:", room_pos)
            obs, reward, done = place(
                env,
                task,
                target_pos=room_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after placing the ball!")
                return
            
        else:
            print("[Task] Cannot proceed: Room is dark or gripper is not closed.")
            if obs.dark:
                print("[Task] The room is dark. Attempting to turn on the light.")
                # Assuming we have a switch to press to turn on the light
                switch_pos = positions['switch']  # Replace 'switch' with the actual switch name
                print("[Task] Pressing the switch at:", switch_pos)
                obs, reward, done = press(switch_pos)
                if done:
                    print("[Task] Task ended after pressing the switch!")
                    return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()