import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions
from scipy.spatial.transform import Rotation as R

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset the task and initialize recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve all object positions
        positions = get_object_positions()

        # Step 1: Rotate gripper to 90 degrees around Z axis
        print("[Task] Rotating gripper to 90 degrees around Z.")
        obs = task.get_observation()
        target_quat = normalize_quaternion(R.from_euler('z', 90, degrees=True).as_quat())
        # Frozen Code Start
        obs, reward, done = rotate(env, task, target_quat)
obs, reward, done = move(env, task, target_pos=side_pos)
        # Frozen Code End
        if done:
            print("[Task] Early termination after Step 1 or 2. Reward:", reward)
            return

        # Step 3: Move to the drawer's anchor position (bottom drawer assumed unlocked)
        anchor_key = 'bottom_anchor_pos' if 'bottom_anchor_pos' in positions else 'anchor-pos-bottom'
        anchor_pos = np.array(positions[anchor_key])
        print(f"[Task] Moving to anchor position: {anchor_key}")
        obs, reward, done = move(env, task, target_pos=anchor_pos)
        if done:
            print("[Task] Early termination after move-to-anchor. Reward:", reward)
            return

        # Step 4: Pull the drawer open
        pull_distance = 0.1  # meters
        pull_axis = 'x'
        print(f"[Task] Pulling drawer open (distance={pull_distance}, axis={pull_axis})")
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis=pull_axis)
        if done:
            print("[Task] Early termination after pull. Reward:", reward)
            return

        # Step 5: Pick up the rubbish
        item_key = 'rubbish' if 'rubbish' in positions else ('item1' if 'item1' in positions else None)
        if item_key is None:
            raise KeyError("No rubbish or fallback item found in positions")
        item_pos = np.array(positions[item_key])
        print(f"[Task] Picking up object: {item_key}")
        obs, reward, done = pick(env, task, target_pos=item_pos)
        if done:
            print("[Task] Early termination after pick. Reward:", reward)
            return

        # Step 6: Place the rubbish into the bin
        bin_key = 'bin'
        if bin_key not in positions:
            raise KeyError("Bin position not found in positions")
        bin_pos = np.array(positions[bin_key])
        print(f"[Task] Placing object into bin: {bin_key}")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Executed all steps. Final reward:", reward)

    except Exception as e:
        print(f"[Task] Exception during execution: {e}")
    finally:
        shutdown_environment(env)
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()