            # Step 5: Rotate gripper back to 0 degrees
            print("[Task] Step 5: Rotating gripper back to 0°")
            obs, reward, done = rotate(env, task, quat_zero)
            if done:
                print("[Task] Terminated after rotation to 0°")
                return

            # Step 6: Pick up the rubbish
            print("[Task] Step 6: Picking up rubbish")
            obs, reward, done = pick(env, task, rubbish_pos)
            if done:
                print("[Task] Terminated after picking rubbish")
                return

            # Step 7: Move to the bin location
            print("[Task] Step 7: Moving to bin")
            obs, reward, done = move(env, task, bin_pos)
            if done:
                print("[Task] Terminated after moving to bin")
                return

            # Step 8: Place the rubbish into the bin
            print("[Task] Step 8: Placing rubbish into bin")
            obs, reward, done = place(env, task, bin_pos)
            if done:
                print("[Task] Completed successfully! Final reward:", reward)
            else:
                print("[Task] Finished plan but done flag is False. Reward:", reward)

        except KeyError as e:
            print(f"[Error] Missing object in positions map: {e}")
        except Exception as e:
            print(f"[Error] Exception during plan execution: {e}")
        finally:
            # Ensure the environment is shut down even if an error occurs
            shutdown_environment(env)

if __name__ == "__main__":
    run_skeleton_task()