import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions
from scipy.spatial.transform import Rotation as R

def run_skeleton_task():
    '''Generic skeleton for running the open‐drawer and rubbish disposal task.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        task.step = recording_step(task.step)
        task.get_observation = recording_get_observation(task.get_observation)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        side_pos = np.array(positions['bottom_side_pos'])
        anchor_pos = np.array(positions['bottom_anchor_pos'])
        rubbish_pos = np.array(positions['rubbish'])
        bin_pos = np.array(positions['bin'])

        # === Oracle Plan Execution ===
        # 1) Compute a quaternion for a 90° rotation about Z
        print("[Task] Computing target orientation: 90° about Z.")
        target_quat = R.from_euler('z', 90, degrees=True).as_quat()

        # [Frozen Code Start]
        obs, reward, done = rotate(env, task, target_quat=target_quat)
        obs, reward, done = move(env, task, target_pos=side_pos)
        obs, reward, done = move(env, task, target_pos=anchor_pos)
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        obs, reward, done = place(env, task, target_pos=bin_pos)
        # [Frozen Code End]

        if done:
            print("[Task] Task completed successfully! Final reward:", reward)
        else:
            print("[Task] Main plan executed but task not flagged done (done=False).")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()