import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import move, pick, place, rotate, pull

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Map PDDL object names to position keys returned by get_object_positions
        side_pos_bottom = positions['bottom_side_pos']
        anchor_pos_bottom = positions['bottom_anchor_pos']
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']

        # === Oracle Plan Execution ===

        # Step 1: Rotate gripper to 90 degrees about Z
        # Quaternion for 90° rotation about Z axis: [x, y, z, w]
        ninety_deg_quat = np.array([0.0, 0.0, np.sin(np.pi/4), np.cos(np.pi/4)])
        print("[Plan] Step 1: rotate gripper to ninety_deg")
[Frozen Code Start]
    obs, reward, done = rotate(env, task, ninety_deg_quat)
obs, reward, done = move(env, task, side_pos_bottom)
[Frozen Code End]
        if done:
            print("[Plan] Task ended after initial rotate/move.")
            return

        # Step 2 (continued): already moved to side position inside frozen code
        print("[Plan] Step 2: move gripper to anchor-pos-bottom")
        obs, reward, done = move(env, task, anchor_pos_bottom)
        if done:
            print("[Plan] Task ended after move to anchor-pos-bottom.")
            return

        # Step 3: Pull the bottom drawer open
        pull_distance = 0.1
        pull_axis = 'x'
        print(f"[Plan] Step 3: pull drawer bottom by {pull_distance}m along {pull_axis}")
        obs, reward, done = pull(env, task, pull_distance, pull_axis)
        if done:
            print("[Plan] Task ended after pulling drawer.")
            return

        # Step 4: Pick up the rubbish on the table
        print("[Plan] Step 4: pick rubbish from table")
        obs, reward, done = pick(env, task, rubbish_pos)
        if done:
            print("[Plan] Task ended after picking rubbish.")
            return

        # Step 5: Place the rubbish into the bin
        print("[Plan] Step 5: place rubbish into bin")
        obs, reward, done = place(env, task, bin_pos)
        if done:
            print("[Plan] Task completed successfully! Reward:", reward)
        else:
            print("[Plan] Executed all steps; final done flag is False. Reward:", reward)

    except Exception as e:
        print(f"[Error] Exception during task execution: {e}")
        raise
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()