        print("[Plan] Step 3: Moving to anchor position of bottom drawer")
        obs, reward, done = move(env, task, target_pos=anchor_pos_bottom)
        if done:
            print("[Error] Episode ended prematurely during move to anchor position.")
            return

        print("[Plan] Step 4: Pulling bottom drawer open")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Error] Episode ended prematurely during pull.")
            return

        print("[Plan] Step 5: Moving to rubbish position")
        obs, reward, done = move(env, task, target_pos=rubbish_pos)
        if done:
            print("[Error] Episode ended prematurely moving to rubbish.")
            return

        print("[Plan] Step 6: Picking up rubbish")
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Error] Episode ended prematurely during pick.")
            return

        print("[Plan] Step 7: Moving to bin position")
        obs, reward, done = move(env, task, target_pos=bin_pos)
        if done:
            print("[Error] Episode ended prematurely moving to bin.")
            return

        print("[Plan] Step 8: Placing rubbish into bin")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Info] Finished placing rubbish into bin.")

        print(f"[Result] Task completed successfully. Final reward: {reward}, done: {done}")
    except Exception as e:
        print(f"[Exception] An error occurred: {e}")
    finally:
        shutdown_environment(env)
        print("===== Environment Shutdown =====")

if __name__ == "__main__":
    run_skeleton_task()